// pause.cpp

#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "main.h"
#include "blitter.h"
#include "graphics.h"
#include "gworld.h"
#include "wdef.h"
#include "pause.h"
#include "random.h"
#include "font.h"
#include "midi.h"
#include "soundfx.h"
#include "keyselect.h"
#include "level.h"
#include "register.h"
#include "keyboard.h"
#include "victory.h"
#include "hiscore.h"
#include "score.h"


typedef struct
{
	float red, green, blue;
}
FRGBColor;

GWorldPtr backWorld, drawWorld, logoWorld, logoMaskWorld, logoAlphaWorld;
SkittlesFontPtr smallFont, bigFont;
FRGBColor backColor[4];
Boolean continueTimeOut;

static int dialogType, dialogStage, dialogTimer, dialogTarget, dialogShade, dialogItem;
static float colorWrap = 0, colorInc;
static Rect logoRect = {0, 0, 111, 246}, lastPauseRect;
static Boolean dialogStageComplete;
static Boolean timeToRedraw = false;

static void ItsTimeToRedraw()
{
	timeToRedraw = true;
}

void DrawRainbowText( SkittlesFontPtr font, char *line, Point dPoint, float wave, int bright )
{
	int length, current;
	int r,g,b;

	current = 0;
	length = strlen(line);
	
	while( line[current] )
	{
		if( bright )
		{
			r = 26 + 5 * sin(wave                    );
			g = 26 + 5 * sin(wave + ((2.*pi) * 1./3.));
			b = 26 + 5 * sin(wave + ((2.*pi) * 2./3.));
		}
		else
		{
			r = 16 + 12 * sin(wave                    );
			g = 16 + 12 * sin(wave + ((2.*pi) * 1./3.));
			b = 16 + 12 * sin(wave + ((2.*pi) * 2./3.));
		}

		BlitCharacter( font, line[current], &dPoint, r, g, b, 1 );			
		
		wave += 0.2;
		current++;
	}
}

#define kEdgeSize 8
static short edge[4][kEdgeSize][kEdgeSize];

void GetEdges( PixMapHandle edgePixMap, const Rect *rect )
{
	Byte *src[4];
	int srcRowBytes, width, height, count;
	
	src[0] = src[1] = src[2] = src[3] = (Byte*) GetPixBaseAddr(edgePixMap);
	srcRowBytes = GetPixRowBytes(edgePixMap);

	width  = rect->right  - rect->left;
	height = rect->bottom - rect->top; 

	src[0] += (srcRowBytes * (rect->top               )) + ((rect->left             ) * 2);
	src[1] += (srcRowBytes * (rect->top               )) + ((rect->right - kEdgeSize) * 2);
	src[2] += (srcRowBytes * (rect->bottom - kEdgeSize)) + ((rect->left             ) * 2);
	src[3] += (srcRowBytes * (rect->bottom - kEdgeSize)) + ((rect->right - kEdgeSize) * 2);
	
	for( count=0; count<4; count++ )
	{
		for( height=0; height<kEdgeSize; height++ )
		{
			memcpy( edge[count][height], src[count], kEdgeSize * 2 );
			src[count] += srcRowBytes;
		}
	}
}

void CurveEdges( PixMapHandle edgePixMap, const Rect *rect )
{
	Byte *src[4];
	int srcRowBytes, width, height, count;
	char edgeMap[4][kEdgeSize][kEdgeSize+1]= { {   "      --",
						                           "    -...",
						                           "   -.xxX",
						                           "  -.xXXX",
						                           " -.xXXXX",
						                           " .xXXXXX",
						                           "-.xXXXXX",
						                           "-.XXXXXX" },
						                         { "--      ",
						                           "...-    ",
						                           "Xxx.-   ",
						                           "XXXx.-  ",
						                           "XXXXx.- ",
						                           "XXXXXx. ",
						                           "XXXXXx.-",
						                           "XXXXXX.-" },
						                         { "-.XXXXXX",
						                           "-.xXXXXX",
						                           " .xXXXXX",
						                           " -.xXXXX",
						                           "  -.xXXX",
						                           "   -.xxX",
						                           "    -...",
						                           "      --" },
						                         { "XXXXXX.-",
						                           "XXXXXx.-",
						                           "XXXXXx. ",
						                           "XXXXx.- ",
						                           "XXXx.-  ",
						                           "Xxx.-   ",
						                           "...-    ",
						                           "--      " } };
	                         	                         
	
	src[0] = src[1] = src[2] = src[3] = (Byte*) (**edgePixMap).baseAddr;
	srcRowBytes = (**edgePixMap).rowBytes & 0x3FFF;

	src[0] += (srcRowBytes * (rect->top               )) + ((rect->left             ) * 2);
	src[1] += (srcRowBytes * (rect->top               )) + ((rect->right - kEdgeSize) * 2);
	src[2] += (srcRowBytes * (rect->bottom - kEdgeSize)) + ((rect->left             ) * 2);
	src[3] += (srcRowBytes * (rect->bottom - kEdgeSize)) + ((rect->right - kEdgeSize) * 2);
	
	// Draw top/bottom border
	{
		short *srcT1 = (short*) (src[0]) + kEdgeSize;
		short *srcB1 = (short*) (src[2] + (srcRowBytes*(kEdgeSize-1))) + kEdgeSize;
		short *srcT2 = srcT1 + (srcRowBytes/2);
		short *srcB2 = srcB1 - (srcRowBytes/2);
		
		for( width = rect->right - rect->left - (kEdgeSize * 2); width > 0; width-- )
		{
			*srcT1 = 0; srcT1++;
			*srcB1 = 0; srcB1++;
			*srcT2 = (*srcT2 >> 1) & 0x3DEF; srcT2++;
			*srcB2 = (*srcB2 >> 1) & 0x3DEF; srcB2++;
		}
	}
	
	// Draw left/right border
	{
		Byte *srcL1 = (src[0] + (srcRowBytes * kEdgeSize));
		Byte *srcR1 = (src[1] + (srcRowBytes * kEdgeSize)) + 2*(kEdgeSize-1);

		Byte *srcL2 = srcL1 + 2;
		Byte *srcR2 = srcR1 - 2;
		
		for( height = rect->bottom - rect->top - (kEdgeSize * 2); height > 0; height-- )
		{
			*(short*)srcL1 = 0; 
			*(short*)srcR1 = 0;
			*(short*)srcL2 = (*(short*)srcL2 >> 1) & 0x3DEF; 
			*(short*)srcR2 = (*(short*)srcR2 >> 1) & 0x3DEF; 
			
			srcL1 += srcRowBytes; 
			srcR1 += srcRowBytes;
			srcL2 += srcRowBytes; 
			srcR2 += srcRowBytes;
		}
	}
		
	// Draw curved edges
	for( count=0; count<4; count++ )
	{
		short *srcS = (short*) src[count];
		
		for( height=0; height<kEdgeSize; height++ )
		{
			for( width=0; width<kEdgeSize; width++ )
			{
				switch( edgeMap[count][height][width] )
				{
					case ' ': 	*srcS = edge[count][height][width]; break;
					case '.': 	*srcS = 0; break;
					case 'x': 	*srcS = (*srcS >> 1) & 0x3DEF; break;
					case '-':	*srcS = (edge[count][height][width] >> 1) & 0x3DEF; break;
					case 'X': 	break;
				}
				srcS++;
			}
			srcS += (srcRowBytes / 2) - kEdgeSize;
		}
	}
}

#define min(x,y) (((x)<(y))?(x):(y))
#define max(x,y) (((x)>(y))?(x):(y))
#define arrsize(x) (sizeof(x)/sizeof(x[0]))

enum
{
	kOpening = 0, 
	kClosing
};

Boolean DrawDialogBox( int animationType, int *target, int skip, float *colorWrap, float colorInc, Rect *pauseRect )
{
	Boolean animationStageComplete = false;
	Rect targetRect[2][19]      = { { { 240 - 10,  320 - 30,  240 + 10,  320 + 30  },
	                                  { 240 - 40,  320 - 120, 240 + 40,  320 + 120 },
	                                  { 240 - 60,  320 - 180, 240 + 60,  320 + 180 },
	                                  { 240 - 70,  320 - 210, 240 + 70,  320 + 210 },
	                                  { 240 - 80,  320 - 230, 240 + 80,  320 + 230 },
	                                  { 240 - 88,  320 - 245, 240 + 88,  320 + 245 },
	                                  { 240 - 95,  320 - 252, 240 + 95,  320 + 252 },
	                                  { 240 - 101, 320 - 255, 240 + 101, 320 + 255 },
	                                  { 240 - 106, 320 - 252, 240 + 106, 320 + 252 },
	                                  { 240 - 110, 320 - 245, 240 + 110, 320 + 245 },
	                                  { 240 - 113, 320 - 238, 240 + 113, 320 + 238 },
	                                  { 240 - 115, 320 - 232, 240 + 115, 320 + 232 },
	                                  { 240 - 116, 320 - 228, 240 + 116, 320 + 228 },
	                                  { 240 - 118, 320 - 232, 240 + 118, 320 + 230 },
	                                  { 240 - 118, 320 - 238, 240 + 118, 320 + 232 },
	                                  { 240 - 119, 320 - 242, 240 + 119, 320 + 242 },
	                                  { 240 - 119, 320 - 244, 240 + 119, 320 + 244 },
	                                  { 240 - 119, 320 - 242, 240 + 119, 320 + 242 },
	                                  { 240 - 120, 320 - 240, 240 + 120, 320 + 240 }
	                                          },
	                                { { 240 - 110, 320 - 220, 240 + 110, 320 + 220 }, 
	                                  { 240 - 105, 320 - 210, 240 + 105, 320 + 210 }, 
	                                  { 240 - 100, 320 - 200, 240 + 100, 320 + 200 }, 
	                                  { 240 - 95,  320 - 190, 240 + 95,  320 + 190 }, 
	                                  { 240 - 90,  320 - 180, 240 + 90,  320 + 180 }, 
	                                  { 240 - 85,  320 - 170, 240 + 85,  320 + 170 }, 
	                                  { 240 - 80,  320 - 160, 240 + 80,  320 + 160 }, 
	                                  { 240 - 75,  320 - 150, 240 + 75,  320 + 150 }, 
	                                  { 240 - 70,  320 - 140, 240 + 70,  320 + 140 }, 
	                                  { 240 - 65,  320 - 130, 240 + 65,  320 + 130 }, 
	                                  { 240 - 60,  320 - 120, 240 + 60,  320 + 120 }, 
	                                  { 240 - 55,  320 - 110, 240 + 55,  320 + 110 }, 
	                                  { 240 - 50,  320 - 100, 240 + 50,  320 + 100 }, 
	                                  { 240 - 45,  320 - 90,  240 + 45,  320 + 90  }, 
	                                  { 240 - 40,  320 - 80,  240 + 40,  320 + 80  }, 
	                                  { 240 - 35,  320 - 70,  240 + 35,  320 + 70  }, 
	                                  { 240 - 30,  320 - 60,  240 + 30,  320 + 60  }, 
	                                  { 240 - 25,  320 - 50,  240 + 25,  320 + 50  }, 	                                
	                                  { 240 - 20,  320 - 40,  240 + 20,  320 + 40  }, 
	                                          }
	                                 };

	int colorInt, shading;
	float colorFrac, nColorFrac;
	Rect newRect;
	
	if( *target > 18 )
	{
		*target = 18;
		animationStageComplete = true;
	}

	colorInt  = floor( *colorWrap );
	colorFrac = *colorWrap - colorInt;

	newRect = targetRect[animationType][*target];
	shading = ((animationType == 0) ? (*target * 24 / 18): (24 - (*target * 2 / 3)));
	
	{
		float r1 = backColor[colorInt      ].red, g1 = backColor[colorInt      ].green, b1 = backColor[colorInt      ].blue,
		      r2 = backColor[(colorInt+1)&3].red, g2 = backColor[(colorInt+1)&3].green, b2 = backColor[(colorInt+1)&3].blue,
		      r3 = backColor[(colorInt+2)&3].red, g3 = backColor[(colorInt+2)&3].green, b3 = backColor[(colorInt+2)&3].blue,
		      r4 = backColor[(colorInt+3)&3].red, g4 = backColor[(colorInt+3)&3].green, b4 = backColor[(colorInt+3)&3].blue;
		
		nColorFrac = 1 - colorFrac;
		
		PrepareForGDrawing( drawWorld );
		
		BlitBlendOver( GetGWorldPixMap(backWorld), &newRect,  (r1 * nColorFrac) + (r2 * colorFrac), 
															  (g1 * nColorFrac) + (g2 * colorFrac), 
															  (b1 * nColorFrac) + (b2 * colorFrac), 
															  (r2 * nColorFrac) + (r3 * colorFrac), 
															  (g2 * nColorFrac) + (g3 * colorFrac), 
															  (b2 * nColorFrac) + (b3 * colorFrac), 
															  (r4 * nColorFrac) + (r1 * colorFrac), 
															  (g4 * nColorFrac) + (g1 * colorFrac), 
															  (b4 * nColorFrac) + (b1 * colorFrac), 
															  (r3 * nColorFrac) + (r4 * colorFrac), 
															  (g3 * nColorFrac) + (g4 * colorFrac), 
															  (b3 * nColorFrac) + (b4 * colorFrac), 
															  shading );

		if( pauseRect->left < newRect.left ) 
		{
			Rect eraseRect = *pauseRect;
			pauseRect->left = eraseRect.right = newRect.left;
			
			CopyBits( GetPortBitMapForCopyBits(backWorld), GetPortBitMapForCopyBits(drawWorld), 
					   &eraseRect, &eraseRect, srcCopy, nil );
		}

		if( pauseRect->right > newRect.right ) 
		{
			Rect eraseRect = *pauseRect;
			pauseRect->right = eraseRect.left = newRect.right;

			CopyBits( GetPortBitMapForCopyBits(backWorld), GetPortBitMapForCopyBits(drawWorld), 
					   &eraseRect, &eraseRect, srcCopy, nil );
		}

		if( pauseRect->top < newRect.top ) 
		{
			Rect eraseRect = *pauseRect;
			pauseRect->top = eraseRect.bottom = newRect.top;

			CopyBits( GetPortBitMapForCopyBits(backWorld), GetPortBitMapForCopyBits(drawWorld), 
					   &eraseRect, &eraseRect, srcCopy, nil );
		}

		if( pauseRect->bottom > newRect.bottom ) 
		{
			Rect eraseRect = *pauseRect;
			pauseRect->bottom = eraseRect.top = newRect.bottom;

			CopyBits( GetPortBitMapForCopyBits(backWorld), GetPortBitMapForCopyBits(drawWorld), 
					   &eraseRect, &eraseRect, srcCopy, nil );
		}

		FinishGDrawing( drawWorld );
	}
	
	*pauseRect = newRect;
	
	*colorWrap += colorInc * skip;
	if( *colorWrap >= 4 ) *colorWrap -= 4;

	*target += skip;

	return animationStageComplete;
}

void DrawDialogCursor( Rect *pauseRect, int *shade )
{
	Point p, q;
    shade;
    
	SetPort( backdropPort );
	GetMouse( &p );
	
	if( p.h < (pauseRect->left      ) ) p.h = pauseRect->left;
	if( p.h > (pauseRect->right  - 5) ) p.h = pauseRect->right  - 5;
	if( p.v < (pauseRect->top       ) ) p.v = pauseRect->top;
	if( p.v > (pauseRect->bottom - 5) ) p.v = pauseRect->bottom - 5;
	q = p;
	
	PrepareForGDrawing( drawWorld );

	BlitCharacter( smallFont, '', &p,  0,  0,  0, 0 );			
	BlitCharacter( smallFont, '', &q, 31, 31, 31, 0 );			
	
	FinishGDrawing( drawWorld );
}

void DrawDialogLogo( Rect *pauseRect, int *shade, int skip )
{
	Rect drawRect;
	int alpha;

	drawRect.left   = (pauseRect->left + ((pauseRect->right - pauseRect->left) * 1 / 2) ) - (logoRect.right / 2);
	drawRect.top    = (pauseRect->top + ((pauseRect->bottom - pauseRect->top) * 28 / 100) ) - (logoRect.bottom / 2);
	drawRect.bottom = drawRect.top + logoRect.bottom;
	drawRect.right  = drawRect.left + logoRect.right;
	
	PrepareForGDrawing( drawWorld );
	
	alpha = (*shade > 63)? 31: (*shade / 2);
	*shade += skip;
		
	BlitWeightedAlphaDualMask( GetGWorldPixMap(drawWorld), GetGWorldPixMap(logoWorld),
	                             GetGWorldPixMap(logoMaskWorld), GetGWorldPixMap(logoAlphaWorld),
                               &drawRect, &logoRect, &logoRect, &logoRect, &drawRect, alpha );

	FinishGDrawing( drawWorld );
}


enum
{ 
	kMusic = 0,		kEndGame,
	kSound,			kPauseGame,
	kControls,		kResume,
	kUnlock,        kSecret,
	kWarp,       	kSoundTest,
    kContinue,      kLater
};

void DrawContinueContents( int *item, int shade )
{
	char line[4][50] = { "Do you want to continue?",
	                     "Yes",
	                     "No",
	                     "" };	                 
	Point dPoint[4] = { {233, 210}, {280, 220}, {280, 400}, {335, 400} }, hPoint = {255, 320};
	static int lastCountdown = 0;
	int index, countdown, fade;
	int r, g, b;
	                 
	sprintf( line[3], "%d credit%c", credits, (credits != 1)? 's': ' ' );

	PrepareForGDrawing( drawWorld );

	for( index=0; index<4; index++ )
	{	
		DrawRainbowText( smallFont, line[index], dPoint[index], (0.25 * index) + (0.075 * shade), 
						  (index == 0)                          ||
						 ((index == 1) && (*item == kContinue)) ||
						 ((index == 2) && (*item == kEndGame )) );
	}
	
	countdown = shade / 100;
	if( countdown < 10 )
	{
		continueTimeOut = false;
		
		if( (countdown != 0) && (countdown != lastCountdown) )
		{
			PlayMono( kContinueSnd );
		}
		lastCountdown = countdown;
		
		if( countdown < 5 )
		{
			r = (countdown * 31) / 5;
			g = 31;
		}
		else
		{
			r = 31;
			g = ((10 - countdown) * 31) / 5;
		}
			
		fade = shade % 100;
		if( fade > 50 ) fade = 50;
		r = ((31 * (49 - fade)) + (r * fade)) / 49;
		g = ((31 * (49 - fade)) + (g * fade)) / 49;
		b = ((31 * (49 - fade))) / 49;
		
		countdown = '9' - countdown;
		hPoint.h -= bigFont->width[countdown] / 2;

		for( shade = 4; shade > 0; shade-- )
		{
			Point hP = hPoint;
			
			hP.h += 2 * shade;
			hP.v += 2 * shade;

			BlitWeightedCharacter( bigFont, countdown, &hP, 0, 0, 0, 20 - 4*shade ); 
		}

		BlitCharacter( bigFont, countdown, &hPoint, r, g, b, 0 ); 
	}
	else
	{
		continueTimeOut = true;
	}
	
	FinishGDrawing( drawWorld );
}

void DrawHiScoreContents( int *item, int shade )
{
	static Pattern dottedLine = { 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33 };
	static Pattern black = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
	Rect dottedRect = {320, 140, 322, 500};
	Point dPoint[3] = { {240, 640}, {260, 640}, {335, 400} }, hPoint = {294, 145};
	int index;		
	char *line[3], *scan;
	
	item; // is unused

	line[0] = highScoreText;
	line[1] = "Please enter your name:";
	line[2] = highScoreRank;

	for( index=0; index<2; index++ )
	{
		scan = line[index];
		while( *scan )
			dPoint[index].h -= smallFont->width[*scan++];
		
		dPoint[index].h /= 2;
	}	
		
	PrepareForGDrawing( drawWorld );

	ForeColor( blackColor );
	PenPat( &dottedLine );
	PenMode( srcOr );
	FrameRect( &dottedRect );
	PenPat( &black );
	PenMode( srcCopy );
		
	for( index=1; index<=highScoreName[0]; index++ )
	{
		BlitCharacter( bigFont, highScoreName[index], &hPoint, 31, 31, 31, 1 );			
		if( hPoint.h >= 475 )
		{
			highScoreName[0] = index;
			break;
		}
	}

	index = ( 1 + sin( TickCount() / 7.5 ) ) * 15;	
	BlitCharacter( bigFont, '|', &hPoint, index, index, 31, 1 );			

	for( index=0; index<3; index++ )
	{	
		DrawRainbowText( smallFont, line[index], dPoint[index], (0.25 * index) + (0.075 * shade), index != 2 );
	}
	
	FinishGDrawing( drawWorld );
}

void DrawRegisterContents( int *item, int shade )
{
	int index;		
	Point dPoint[4] = { {240, 150}, {260, 160}, {305, 170}, {305, 400} };
	char line[4][50] = {  "Sorry, you must register Candy Crisis",
	                      "to gain access to two player mode!",
	                      "Register Now",
	                      "Not Yet" };
	
	PrepareForGDrawing( drawWorld );

	for( index=0; index<4; index++ )
	{	
		DrawRainbowText( smallFont, line[index], dPoint[index], (0.25 * index) + (0.075 * shade), 
						  (index == 0)                          ||
						  (index == 1)                          ||
						 ((index == 2) && (*item == kUnlock  )) ||
						 ((index == 3) && (*item == kLater   )) );
	}

	FinishGDrawing( drawWorld );
}

void DrawPauseContents( int *item, int shade )
{
	Point dPoint;
	int itemCount = IsRegistered()? 6: 7;
	int index;
	char line[7][20] = { " Music",           " End Game",
	                     " Sound",           " Hide Game",
	                     " Controls",        " Resume",
	                     " Register Now"                       };

	
	if( level == kTutorialLevel ) strcpy( line[1], " Skip Tutorial" );
	
	if( !musicOn ) line[0][0] = '';
	if( !soundOn ) line[2][0] = '';

	PrepareForGDrawing( drawWorld );	
	
	for( index=0; index<itemCount; index++ )
	{	
		dPoint.h = (index & 1)? 340: 180;
		dPoint.v = 240 + ((index & ~1) * 15);
		
		DrawRainbowText( smallFont, line[index], dPoint, (0.25 * index) + (0.075 * shade), *item == index );
	}
	
	FinishGDrawing( drawWorld );
}

Boolean ContinueSelected( int *item, unsigned char inKey )
{
	Rect yes = {280, 220, 300, 260}, no = {280, 400, 300, 440};
	Point p;
	
	inKey; // is unused 
	
	if( continueTimeOut )
	{
		*item = kEndGame;
		return true;
	}
	
	if( pauseKey )
	{
		*item = kContinue;
		return true;
	}
	
	SetPort( backdropPort );
	GetMouse( &p );

	     if( PtInRect( p, &yes ) ) *item = kContinue;	
	else if( PtInRect( p, &no  ) ) *item = kEndGame;
	else *item = -1;
	
	return ( Button( ) && (*item != -1) );
}

Boolean RegisterSelected( int *item, unsigned char inKey )
{
	Rect registerNow = {305, 170, 325, 290}, registerLater = {305, 400, 325, 470};
	Point p;
	
	inKey; // is unused 
		
	if( pauseKey )
	{
		*item = kLater;
		return true;
	}
	
	SetPort( backdropPort );
	GetMouse( &p );

	     if( PtInRect( p, &registerNow   ) ) *item = kUnlock;	
	else if( PtInRect( p, &registerLater ) ) *item = kLater;
	else *item = -1;
	
	if( Button( ) )
	{
		switch( *item ) 
		{
			case kUnlock:
				if( !IsRegistered() )
				{
					PlayMono( kClick );
					Register( true );
					ItsTimeToRedraw();
				}
				return true;
			
			case kLater:
				PlayMono( kClick );
				return true;
		}
	}
	
	return false;
}

Boolean HiScoreSelected( int *item, unsigned char inKey )
{
	// return
	if( inKey == 13 ) 
	{
		if( highScoreName[0] > 0 )
		{
			*item = kResume;
			PlayMono( kSquishy );
			return true;
		}
		else
		{
			PlayMono( kClick );
		}
	}
	
	// backspace
	else if( inKey == 8 )
	{
		if( highScoreName[0] > 0 )
		{
			highScoreName[0]--;
			PlayMono( kClick );
		}
	}
	
	// characters
	else if( bigFont->width[inKey] != 0 )
	{
		highScoreName[++highScoreName[0]] = inKey;
		PlayMono( kPlace );
	}
	
	*item = -1;
	return false;
}

Boolean PauseSelected( int *item, unsigned char inKey )
{
	Rect targetRect[] = 
	{	
		{ 240, 180, 260, 320 },
		{ 240, 340, 260, 480 },
		{ 270, 180, 290, 320 },
		{ 270, 340, 290, 480 },
		{ 300, 180, 320, 320 },
		{ 300, 340, 320, 480 },
		{ 330, 180, 350, 320 },
	    { 120, 550, 130, 560 }
	};

	static Boolean lastDown = false;
	int trigger;
	int index;
	Point p;
	
	SetPort( backdropPort );
	GetMouse( &p );
	
	trigger = Button();
	if( pauseKey || inKey == 0x1B )
	{
		*item = kResume;
		trigger = true;
	}
	else
	{
		*item = -1;
		for( index=0; index<arrsize(targetRect); index++ )
		{
			if( PtInRect( p, &targetRect[index] ) )
			{
				*item = index;
			}
		}
	}
	
	if( trigger )
	{
		if( !lastDown )
		{
			lastDown = true;
			
			switch( *item )
			{
				case kSound:     PlayMono( kClick ); soundOn = !soundOn; PlayMono( kClick ); return false;

				case kMusic:     PlayMono( kClick ); musicOn = !musicOn; return false;
				case kEndGame:   PlayMono( kClick );                     return true;
				case kResume:    PlayMono( kClick );                     return true;

				case kPauseGame: 
					PlayMono( kClick );
					GoToBackground( true, true );
					ItsTimeToRedraw();
					return false;

				case kUnlock:
					if( !IsRegistered() )
					{
						PlayMono( kClick );
						Register( true );
						ItsTimeToRedraw();
					}
					return false;
					
				case kControls:  
					PlayMono( kClick );
					KeyboardSetup( );  
					ItsTimeToRedraw();
					return false;
				
				case kSecret:
					if( CommandKeyIsPressed( ) )
					{
						*item = kWarp;
						level = Warp( );
						return true;
					}
					else if( OptionKeyIsPressed( ) )
					{
						SoundTest( );
						ItsTimeToRedraw();
					}
					return false;
			}
		}
	}
	else
	{
		lastDown = false;
	}
	
	
	return false;
}

void HandleDialog( int type )
{	
	int count;
	const float lighten[4] = {12, 6, 0, 6};
	const Rect boardWorldZRect = {0, 0, kBlobVertSize * (kGridDown-1), kBlobHorizSize * kGridAcross};
	const Rect fullRect = { 0, 0, 480, 640 };
	int skip = 1;
	char inKey;
	Rect pauseRect, joinRect;
	
	// Remember dialog info
	dialogType = type;
	dialogStage = kOpening;
	colorWrap = 0;
	colorInc = (RandomBefore(250) + 250.0) / 10000.0;

	// Skittles font
	smallFont = GetFont( picFont );

	// Hi score font
	bigFont = nil;
	if( type == kHiScoreDialog )
	{
		bigFont = GetFont( picHiScoreFont );
	}
	
	// Continue font
	if( type == kContinueDialog )
	{
		bigFont = GetFont( picContinueFont );
	}
	
	// Pick some colors to animate
	PrepareForGDrawing( boardWorld[0] );
	for( count=0; count<4; count++ )
	{
		RGBColor inColor;
		
		GetCPixel( RandomBefore( boardWorldZRect.right ), RandomBefore( boardWorldZRect.bottom ), &inColor );
	
		backColor[count].red   = inColor.red   * (32./65536.);
		backColor[count].green = inColor.green * (32./65536.);
		backColor[count].blue  = inColor.blue  * (32./65536.);

		backColor[count].red   = min( 31, backColor[count].red   + lighten[count] );
		backColor[count].green = min( 31, backColor[count].green + lighten[count] );
		backColor[count].blue  = min( 31, backColor[count].blue  + lighten[count] );
	}
	FinishGDrawing( boardWorld[0] );

	// Get some graphics that we're going to need
	InitGWorld( &logoWorld, &logoRect, 16 );
	DrawPictInGWorld( logoWorld, picLogo ); 

	InitGWorld( &logoAlphaWorld, &logoRect, 16 );
	DrawPictInGWorld( logoAlphaWorld, picLogoAlpha ); 

	InitGWorld( &logoMaskWorld, &logoRect, 1 );
	DrawPictInGWorld( logoMaskWorld, picLogoMask ); 
	

	// Get a copy of the current game window contents
	InitGWorld( &backWorld, &fullRect, 16 );

	SetPort( backdropPort );	
	CopyBits( GetPortBitMapForCopyBits(backdropPort), GetPortBitMapForCopyBits(backWorld),
			   &fullRect,  &fullRect,  srcCopy,  nil );

	InitGWorld( &drawWorld, &fullRect, 16 );
	
	PrepareForGDrawing( drawWorld );
	CopyBits( GetPortBitMapForCopyBits(backWorld), GetPortBitMapForCopyBits(drawWorld),
			   &fullRect,  &fullRect,  srcCopy,  nil );
	FinishGDrawing( drawWorld );

	//
		
	PlayMono( kWhomp );
	dialogTimer = TickCount();
	dialogTarget = 0;
	dialogShade = 0;
	dialogStageComplete = false;
	dialogItem = -1;
	lastPauseRect.top = lastPauseRect.left = 9999;
	lastPauseRect.bottom = lastPauseRect.right = -9999;

	while( ((dialogStage != kClosing) || !dialogStageComplete) && !finished )
	{
		dialogTimer += skip;

		// Check mouse and keyboard
		inKey = CheckKeys( true, nil, ItsTimeToRedraw );
		if( (dialogStage == kOpening) && dialogStageComplete )
		{
			Boolean (*DialogSelected[])( int *item, unsigned char inKey ) =
			{
				PauseSelected,
				HiScoreSelected,
				ContinueSelected,
				RegisterSelected
			};
			
			if( DialogSelected[dialogType]( &dialogItem, inKey ) )
			{
				dialogStage = kClosing; 
				dialogTarget = 0;
			}
		}

		// Do animation ...
		pauseRect = lastPauseRect;
		dialogStageComplete = DrawDialogBox( dialogStage, &dialogTarget, skip, &colorWrap, colorInc, &pauseRect );
		GetEdges( GetGWorldPixMap(backWorld), &pauseRect );

		if( (dialogStage == kOpening) && dialogStageComplete )
		{
			void (*DialogDraw[])( int *item, int shade ) =
			{
				DrawPauseContents,
				DrawHiScoreContents,
				DrawContinueContents,
				DrawRegisterContents
			};

			// Refresh screen if necessary
			if( timeToRedraw )
			{
				CopyBits( GetPortBitMapForCopyBits(backWorld), GetPortBitMapForCopyBits(backdropPort), 
						   &fullRect,  &fullRect,  srcCopy,  nil );
				timeToRedraw = false;
			}
			
			// ... and fade in the logo
			DrawDialogLogo( &pauseRect, &dialogShade, skip );
			
			// ... and animation is complete so add content			
			DialogDraw[dialogType]( &dialogItem, dialogShade );
			
			// ... and cursor
			DrawDialogCursor( &pauseRect, &dialogShade );
		}

		CurveEdges( GetGWorldPixMap(drawWorld), &pauseRect );

		// Draw new animation on screen
		UnionRect( &lastPauseRect, &pauseRect, &joinRect );
		
		SetPort(backdropPort);
		ForeColor( blackColor );
		BackColor( whiteColor );
		CopyBits( GetPortBitMapForCopyBits(drawWorld), GetPortBitMapForCopyBits(backdropPort), 
				   &joinRect,  &joinRect,  srcCopy,  nil );
		
		lastPauseRect = pauseRect;

		// Wait for next frame
		if( dialogTimer <= TickCount( ) )
		{
			dialogTimer = TickCount( );
			skip = 2;
		}
		else
		{
			skip = 1;
			while( dialogTimer > TickCount( ) ) { MPYield(); }
		}
	}
	
	// Bring back previous screen
	CopyBits( GetPortBitMapForCopyBits(backWorld), GetPortBitMapForCopyBits(backdropPort), 
			   &fullRect,  &fullRect,  srcCopy,  nil );

	// Dispose the GWorlds and fonts we used
	DisposeGWorld( backWorld );
	DisposeGWorld( drawWorld );
	DisposeGWorld( logoWorld );
	DisposeGWorld( logoAlphaWorld );
	DisposeGWorld( logoMaskWorld );
	DisposeFont( smallFont );
	if( bigFont != nil ) DisposeFont( bigFont );
		
	switch( dialogItem )
	{
		case kEndGame:
			ChooseMusic( -1 );
			AddHiscore( score[0] );
			if( players == 1 )
			{
				ShowGameOverScreen( );
			}
			else
			{
				QuickFadeOut(nil);
			}
			
			showStartMenu = true;
			break;
		
		case kContinue:
			displayedScore[0] = score[0] = roundStartScore[0];
			ShowScore( 0 );
			BeginRound( true );
			break;
			
		case kWarp:
		{
			int newLevel = level;
			
			InitGame( OptionKeyIsPressed()? kAIControl: kPlayerControl, kAIControl ); // this clears "level"
			level = newLevel;	
			BeginRound( true );	
			break;
		}
	}
}